/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWPropertyMenuItem;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWOperationSelectionDialog;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.design.property.tables.VWComponentInstructionsTableModel;
import filenet.vw.toolkit.design.property.tables.VWComponentParametersTableModel;
import filenet.vw.toolkit.design.property.tables.VWParamExpressionCellEditor;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellItem;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWComponentStepGeneralTab
extends JPanel
implements IVWPropertyTab,
DocumentListener,
IVWPropertyChangeSource,
TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private VWCompoundStepDefinition m_stepDefinition = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private Vector m_changedItems = null;
    private boolean m_bIsFirstTime = true;
    private VWOperationSelectionDialog m_operationSelectionDialog = null;
    private JTextField m_nameTextField = null;
    private VWToolbarBorder m_instructionsToolbar = null;
    private VWComponentInstructionsTableModel m_instructionsTableModel = null;
    private VWTable m_instructionsTable = null;
    private VWComponentParametersTableModel m_parametersTableModel = null;
    private VWTable m_parametersTable = null;

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bIsFirstTime) {
            this.m_bIsFirstTime = false;
            if (this.m_parametersTable != null) {
                int width = (this.m_parametersTable.getViewPortWidth() - 20) / 3;
                int[] columnSizes = new int[]{width, width - 30, 20, width + 30};
                this.m_parametersTable.fitColumnsInTable(columnSizes);
            }
        }
    }

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(5, 5, 5, 10);
            this.add((Component)this.getNamePanel(), gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(2, 5, 2, 15);
            this.add((Component)this.createInstructionsBorder(), gbCons);
            ++gbCons.gridx;
            gbCons.insets = new Insets(2, 5, 2, 10);
            this.add((Component)this.createParametersPanel(), gbCons);
            this.setSelectedStep(vwMapNode);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedStep(VWMapNode vwMapNode) {
        if (vwMapNode == null || vwMapNode == this.m_stepDefinition) {
            return;
        }
        this.m_stepDefinition = (VWCompoundStepDefinition)vwMapNode;
        try {
            this.m_nameTextField.getDocument().removeDocumentListener(this);
            this.m_nameTextField.setText("");
            if (this.m_stepDefinition != null) {
                this.m_nameTextField.setText(this.getDisplayName());
            }
            int nButtons = 0x10000003;
            this.m_instructionsToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_instructionsToolbar.getClientPanel(), 2, nButtons));
            this.m_parametersTableModel.reinitialize(null);
            this.m_instructionsTableModel.reinitialize(this.m_stepDefinition);
            if (this.m_instructionsTableModel.getRowCount() > 0) {
                this.m_instructionsTable.getSelectionModel().setSelectionInterval(0, 0);
            }
            this.setEnabled(this.m_authPropertyData.isCurrentMapEditable());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_nameTextField.getDocument().addDocumentListener(this);
        }
    }

    public void releaseReferences() {
        if (this.m_nameTextField != null) {
            this.m_nameTextField.getDocument().removeDocumentListener(this);
            this.m_nameTextField = null;
        }
        if (this.m_instructionsToolbar != null) {
            this.m_instructionsToolbar.removeToolbarBorderActionNotifier(this);
            this.m_instructionsToolbar.releaseReferences();
            this.m_instructionsToolbar = null;
        }
        if (this.m_operationSelectionDialog != null) {
            this.m_operationSelectionDialog.dispose();
            this.m_operationSelectionDialog = null;
        }
        this.m_authPropertyData = null;
        this.m_stepDefinition = null;
        this.removeAll();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.handleDocumentEvent(event);
    }

    public void notifyPropertyChange() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 501);
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (!event.getSource().equals(this.m_instructionsTable.getModel())) break;
                this.updateTableSelection(this.m_instructionsTable, nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (event.getSource().equals(this.m_instructionsTable.getSelectionModel())) {
                this.onSelectedInstruction();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            int nSelectedRow = this.m_instructionsTable.getSelectedRow();
            switch (event.getID()) {
                case 16: {
                    if (this.m_operationSelectionDialog == null) {
                        this.m_operationSelectionDialog = new VWOperationSelectionDialog(this.m_authPropertyData);
                    }
                    this.m_operationSelectionDialog.show();
                    if (this.m_operationSelectionDialog.getStatus() != 0) break;
                    this.m_instructionsTableModel.addItems(this.m_operationSelectionDialog.getQueueName(), this.m_operationSelectionDialog.getSelectedOperations());
                    if (this.m_instructionsTableModel.getRowCount() <= 0 || this.m_instructionsTable.getSelectedRow() != -1) break;
                    this.m_instructionsTable.getSelectionModel().setSelectionInterval(0, 0);
                    break;
                }
                case 1: {
                    this.m_instructionsTableModel.moveItemUp(nSelectedRow);
                    this.updateTableSelection(this.m_instructionsTable, nSelectedRow - 1);
                    break;
                }
                case 2: {
                    this.m_instructionsTableModel.moveItemDown(nSelectedRow);
                    this.updateTableSelection(this.m_instructionsTable, nSelectedRow + 1);
                    break;
                }
                case 0x10000000: {
                    this.m_instructionsTableModel.deleteItem(nSelectedRow);
                    this.updateTableSelection(this.m_instructionsTable, nSelectedRow - 1);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getNamePanel() {
        try {
            VWToolbarBorder stepNameBorder = new VWToolbarBorder(VWResource.s_stepNameStr);
            JPanel childPanel = stepNameBorder.getClientPanel();
            childPanel.setLayout(new BorderLayout());
            this.m_nameTextField = new JTextField("", 15);
            this.m_nameTextField.getDocument().addDocumentListener(this);
            childPanel.add((Component)this.m_nameTextField, "First");
            return stepNameBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private VWToolbarBorder createInstructionsBorder() {
        try {
            int nFlags = 0x10000013;
            this.m_instructionsToolbar = new VWToolbarBorder(VWResource.s_operations, nFlags);
            this.m_instructionsToolbar.addToolbarBorderActionNotifier(this);
            JPanel instructionsPanel = this.m_instructionsToolbar.getClientPanel();
            instructionsPanel.setLayout(new BorderLayout());
            this.m_instructionsTableModel = new VWComponentInstructionsTableModel(this.m_authPropertyData);
            this.m_instructionsTableModel.addTableModelListener(this);
            this.m_instructionsTable = new VWTable(this.m_instructionsTableModel);
            this.m_instructionsTable.setDefaultRenderer(String.class, new VWToolTipTableCellRenderer());
            this.m_instructionsTable.getSelectionModel().setSelectionMode(0);
            this.m_instructionsTable.getSelectionModel().addListSelectionListener(this);
            instructionsPanel.add((Component)new JScrollPane(this.m_instructionsTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_instructionsToolbar;
    }

    private JPanel createParametersPanel() {
        try {
            VWToolbarBorder parametersToolbar = new VWToolbarBorder(VWResource.s_operationParametersStr, 0x40000000);
            JPanel parametersPanel = parametersToolbar.getClientPanel();
            parametersPanel.setLayout(new BorderLayout());
            this.m_parametersTableModel = new VWComponentParametersTableModel(this.m_authPropertyData);
            this.m_parametersTable = new VWTable(this.m_parametersTableModel);
            this.m_parametersTable.setDefaultRenderer(String.class, new VWToolTipTableCellRenderer());
            this.m_parametersTable.setDefaultRenderer(VWToolTipTableCellItem.class, new VWToolTipTableCellRenderer());
            TableColumn tcElement = this.m_parametersTable.getColumnModel().getColumn(3);
            if (tcElement != null) {
                tcElement.setCellEditor(new VWParamExpressionCellEditor(this.m_authPropertyData));
            }
            parametersPanel.add((Component)new JScrollPane(this.m_parametersTable), "Center");
            return parametersToolbar;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private String getDisplayName() {
        if (this.m_stepDefinition != null) {
            return VWPropertyMenuItem.getDisplayName(this.m_stepDefinition);
        }
        return null;
    }

    private void handleDocumentEvent(DocumentEvent event) {
        if (this.m_stepDefinition == null) {
            return;
        }
        if (event.getDocument() == this.m_nameTextField.getDocument()) {
            this.updateName();
        }
    }

    private void updateName() {
        try {
            if (this.m_stepDefinition != null && this.m_nameTextField != null) {
                String name = this.m_nameTextField.getText();
                String blankName = VWPropertyMenuItem.getBlankName(this.m_stepDefinition);
                if ((name.length() == 0 || name.equals(blankName)) && this.m_stepDefinition.getName() == null) {
                    return;
                }
                this.m_stepDefinition.setName(name);
                this.m_authPropertyData.setDirty();
                this.m_changedItems = new Vector();
                this.m_changedItems.addElement(this.m_stepDefinition);
                this.notifyPropertyChange();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateTableSelection(JTable table, int nRow) {
        if (table == null) {
            return;
        }
        if (nRow == table.getSelectedRow()) {
            table.clearSelection();
        }
        if (nRow > -1 && nRow < table.getRowCount()) {
            table.setRowSelectionInterval(nRow, nRow);
        } else if (table.equals(this.m_instructionsTable)) {
            this.onSelectedInstruction();
        }
    }

    private void onSelectedInstruction() {
        try {
            VWInstructionDefinition vwInstructionDef = this.m_instructionsTableModel.getItemAt(this.m_instructionsTable.getSelectedRow());
            if (vwInstructionDef == null) {
                int nButtons = 0x10000003;
                this.m_instructionsToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_instructionsToolbar.getClientPanel(), 2, nButtons));
            } else {
                int nDisableButtons = 0;
                int nEnableButtons = 0x10000000;
                int nSelectedRow = this.m_instructionsTable.getSelectedRow();
                int nRowCount = this.m_instructionsTableModel.getRowCount();
                if (nSelectedRow == 0) {
                    nDisableButtons |= 1;
                } else {
                    nEnableButtons |= 1;
                }
                if (nSelectedRow == nRowCount - 1) {
                    nDisableButtons |= 2;
                } else {
                    nEnableButtons |= 2;
                }
                if (nDisableButtons != 0) {
                    this.m_instructionsToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_instructionsToolbar.getClientPanel(), 2, nDisableButtons));
                }
                this.m_instructionsToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_instructionsToolbar.getClientPanel(), 1, nEnableButtons));
            }
            this.m_parametersTable.stopEditing();
            this.m_parametersTableModel.reinitialize(vwInstructionDef);
            this.updateTableSelection(this.m_parametersTable, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

